﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="ProjectBudget.aspx.cs" Inherits="GUI.Pages.ProjectBudget" %>

<%@ Register TagPrefix="uc" Namespace="GUI.Controls" Assembly="GUI" %>
<%@ Register Src="~/Controls/ProjectNavTest.ascx" TagName="ProjectNavTest" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:ProjectNavTest ID="ProjectNavTest" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="portlet light bordered light-blue">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject bold font-dark uppercase">  <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_Budget %>" /> </span>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <div class="form-body">
                             <asp:HiddenField runat="server" ID="txtProjectBudgetId"/>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Budget_Institution %>" /></label>
                                    <div class="input-group">
                                         <asp:DropDownList runat="server" ValidationGroup="Validacija" CssClass="form-control" ID="ddlOrgUnit" />
                                        <span class="input-group-btn">
                                            <asp:LinkButton ID="btnAddOrganization" OnClick="BtnAddClick" CssClass="btn blue" runat="server">
                                                <i class="fa fa-plus"></i>
                                            </asp:LinkButton>	
                                        </span>
                                    </div> 
                                    <span class="help-block"> <asp:RequiredFieldValidator ID="ddlOrgUnitRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="ddlOrgUnit" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Amount %>" /></label>
                                    <div class="form-group">
                                         <telerik:RadNumericTextBox Skin="Bootstrap" Width="100%" Type="Number" ValidationGroup="Validacija" Font-Bold="True" runat="server" ID="txtValue" NumberFormat-DecimalDigits="2"/>
                                    </div>
                                    <span class="help-block"><asp:RequiredFieldValidator ID="txtValueRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="txtValue" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span> 
                                </div>
                            </div>
                            
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label"> <asp:Literal ID="Literal9" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Currency %>" /></label>
                                    <div class="form-group">
                                          <asp:DropDownList CssClass="form-control"  runat="server" ValidationGroup="Validacija" ID="ddlCurrency" />
                                    </div>
                                    <span class="help-block"><asp:RequiredFieldValidator ID="ddlCurrencyRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" Enabled="false" ControlToValidate="ddlCurrency" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span> 
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal10" runat="server" Text="<%$ Resources:ProjectManagementUI, Budget_CalculatedAmount %>" /></label>
                                    <div class="form-group">
                                            <telerik:RadNumericTextBox Skin="Bootstrap" Width="100%" Type="Number" Font-Bold="True" runat="server" ID="txtComputedValue" NumberFormat-DecimalDigits="2" OnBlur="javascript:Validator();" />
                                    </div>
                                    <span class="help-block"><asp:RequiredFieldValidator ID="txtComputedValueRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="txtComputedValue" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal6" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span> 
                                </div>
                            </div>

                            <div class="col-md-2">
                                 <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal11" runat="server" Text="<%$ Resources:ProjectManagementUI, Budget_CalculatedCurrency %>" /></label>
                                    <div class="form-group">
                                           <asp:DropDownList CssClass="form-control" runat="server" ValidationGroup="Validacija" ID="ddlComputedCurrency" />
                                    </div>
                                    <span class="help-block"><asp:RequiredFieldValidator ID="ddlComputedCurrencyRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="ddlComputedCurrency" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal7" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span> 
                                </div>
                            </div>
                        </div>

                        <div class="form-actions right">
                                <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>" runat="server" />
                                <asp:Button ID="btnNew" OnClick="BtnNewClick" CssClass="btn blue" Text="<%$ Resources:ProjectManagementUI, Common_New %>" runat="server" />
                        </div>

                   

                         <telerik:RadGrid ID="grdProjectBudget" runat="server" OnItemCommand="grdProjectBudgetItemCommand" CssClass="kendo-table" Skin="Bootstrap">
                                <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>" CssClass="table table-striped table-hover"
                                    ShowFooter="False" AutoGenerateColumns="False" AllowCustomSorting="false" DataKeyNames="Id">
                                    <Columns>
                                        <telerik:GridBoundColumn UniqueName="IdColumn" HeaderText="Id" DataField="Id" />
                                        <telerik:GridBoundColumn UniqueName="OrgUnitColumn" SortExpression="OrganizarionUnitId" HeaderText="<%$ Resources:ProjectManagementUI, Codes_Institution %>"
                                            DataField="OrganizationUnit.NameLocalized" />
                                        <telerik:GridBoundColumn UniqueName="ValueColumn" SortExpression="Value" HeaderText="<%$ Resources:ProjectManagementUI, Common_Amount %>"
                                            DataField="Value" DataFormatString="{0:##########.##}" />
                                        <telerik:GridBoundColumn UniqueName="CurrencyColumn" SortExpression="Currency" HeaderText="<%$ Resources:ProjectManagementUI, Common_Currency %>"
                                            DataField="Currency.NameLocalized" />
                                        <telerik:GridBoundColumn UniqueName="ComputedValueColumn" SortExpression="ComputedValue" HeaderText="<%$ Resources:ProjectManagementUI, Budget_CalculatedAmount %>"
                                            DataField="ComputedValue" />
                                        <telerik:GridBoundColumn UniqueName="ComputedCurrencyColumn" SortExpression="ComputedCurrency" HeaderText="<%$ Resources:ProjectManagementUI, Budget_CalculatedCurrency %>"
                                            DataField="ComputedCurrency.NameLocalized" />
                                        <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderStyle-Width="5%"
                                            ButtonCssClass="btn btn-sm blue" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Choose %>"/>
                                        <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%"
                                            ButtonCssClass="btn btn-sm red" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>"
                                            ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>" />
                                    </Columns>
                                </MasterTableView>
                            </telerik:RadGrid>  
                        </div>
                    </div>
                </div>
            </div>
        </div>   
  </asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
     <script type="text/javascript">
        $(document).ready(function () {
            Validator();
        });
          
        function Validator() {
            var vrednost = document.getElementById("<%= txtComputedValue.ClientID%>").value;
            var validator1 = document.getElementById("<%= txtComputedValueRequired.ClientID%>");
            var validator2 = document.getElementById("<%= ddlComputedCurrencyRequired.ClientID%>");
            var valuta = document.getElementById("<%=ddlComputedCurrency.ClientID%>");
            if (vrednost != "") {
                                ValidatorEnable(validator1, true);
                                ValidatorEnable(validator2, true);
                            }
                            else {
                                ValidatorEnable(validator1, false);
                                ValidatorEnable(validator2, false);
                                valuta.value = "";
                            }
                        }
        </script>
</asp:Content>